#ifndef __I2C_H
#define __I2C_H

/* 

	I2C drivers, by Mauro Grassi, September 2010.
	
*/


#include "hardwarestate.h"
#include "vm.h"

#define I2C_TRIS_SCL1		(TRISBbits.TRISB4)
#define I2C_TRIS_SDA1		(TRISBbits.TRISB5)

extern unsigned char I2CBuffer[I2C_BUFFER_SIZE];

unsigned int getI2C(VIRTUAL_MACHINE* vm, unsigned char address, unsigned char* data, unsigned int dataLengthMax);
unsigned int putI2C(VIRTUAL_MACHINE* vm, unsigned char address, unsigned char* data, unsigned int dataLengthMax);
unsigned int putI2CTwoBytes(VIRTUAL_MACHINE* vm, unsigned char address, unsigned char data1, unsigned char data2);
unsigned int putI2COneByte(VIRTUAL_MACHINE* vm, unsigned char address, unsigned char data1);
unsigned int getI2CTwoBytes(VIRTUAL_MACHINE* vm, unsigned char address);
unsigned int getI2COneByte(VIRTUAL_MACHINE* vm, unsigned char address);
void closeI2CState(I2C_DESCRIPTOR* systemState);
void initI2CState(I2C_DESCRIPTOR* systemState);

#endif
